CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    IF  NOT EXISTS (SELECT 1 FROM information_schema.columns 
                    WHERE table_name= 'pdv_nsu_qr_linx') THEN 
			
		CREATE TABLE pdv_nsu_qr_linx (
			cd_ctr numeric(6) NOT NULL DEFAULT 0,
			id_pos varchar(50) NULL,
			id_payment varchar(50) NULL,
			id_order varchar(50) NULL,
			st_pagamento numeric(1) NOT NULL DEFAULT 0,
			id_transaction varchar(50) NULL,
			vlr_qr_linx numeric(10,2) NULL,
			CONSTRAINT pdv_nsu_qr_linx_pkey PRIMARY KEY (cd_ctr)
		);
		
		ALTER TABLE pdv_nsu_qr_linx OWNER TO postgres;
		GRANT ALL ON TABLE pdv_nsu_qr_linx TO postgres;
		
        RAISE NOTICE 'Tabela pdv_nsu_qr_linx CRIADA com sucesso.';
    ELSE 
		RAISE NOTICE 'Tabela pdv_nsu_qr_linx já EXISTE.'; 
    END IF; 
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();